package Singleton;

public class SingleObject {

	//create an object of SingleObject
	//private static SingleObject instance = new SingleObject();
	private static SingleObject instance;

	private String nome="Andrea";
	
	public String getNome() {
		return nome;
	}

	public void setNome(String nome) {
		this.nome = nome;
	}

	//make the constructor private so that this class cannot be
	//instantiated
	private SingleObject(){}

	//Get the only object available
	public static SingleObject getInstance(){
		if (instance==null) {
			instance=new SingleObject();
		}
		return instance;
	}

	public void showMessage(){
		System.out.println("Hello "+nome);
	}
}